/*!
 * Copyright (c) 2005, Freescale Semiconductor
 *
 * Freescale Confidential Proprietary
 * \file    mcu_hw_config.h
 * \brief   Header used to select the desired core.
 * \author  a20639
 * \version 4.1a
 * \date    2005/08/11 20:44:37 
 * 
 * \b Description:
 *
 * Header that includes the declaration of the methods used to
 * configure the hardware
 *
 * \b Department: Freescale Radio Products Division 
 *
 * \b Project: SMAC (Simple Media Access Controller)
 *
 * \b History:
 * - 11/16/2005 Doc. update to Doxygen compliant by Gonzalo Delgado 
 * Huitron rgd04c
 */ 

#ifndef _MCU_HW_CONFIG_H
#define _MCU_HW_CONFIG_H
//#include "freescale_radio_hardware.h"
#include "smac_pub_def.h"

#ifdef  __cplusplus
extern "C" 
{
#endif


//#define MCU_LOW_POWER_WHILE() _asm wait			/*!<Low power Wait instruction*/

//void AssertCE(void);            
//void DeAssertCE(void);          
void RTXENDeAssert(void) ;      
void RTXENAssert(void);         
void MC13192Wake(void);         
void MC13192Restart(void);
void MC13192ContReset(void);

// MNT - 4/6/2007 - QSPI CS is now configured as a GPIO
void AssertCE(void);
void DeAssertCE(void);
#define EnableInterrupts
#define DisableInterrupts


//#define IRQFLAG                     IRQSC_IRQF	 /*!< IRQ Flag*/
//#define IRQACK()                     /*!< IRQ Acknowledge enabled - Does nothing*/
//#define IRQInit()                   IRQSC = 0x14  /*!< Configures IRQ*/
//#define IRQPinEnable()              IRQSC = 0x16  /*!<Enables IRQ pin */
//#define IRQ_Disable()               IRQSC = 0x00;/*!< Set for negative edge. */
//#define MC13192_IRQ_Disable()       MC13192_IRQ_SOURCE = MC13192_IRQ_SOURCE & ~(0x06) /*!<Disables MC13192 transceiver */
//#define MC13192_IRQ_Enable()        MC13192_IRQ_SOURCE = MC13192_IRQ_SOURCE | (0x02)  /*!<Enables MC13192 transceiver */

//    MC13192_IRQ_SOURCE = gu8IRQValue;
#define CLEAR_IRQ_FLAG()            IRQACK()	 /*!< Clears IRQ flag*/


/* Declarations */

/* Function Prototypes */
void SMAC_GPIOInit(void);
#if defined (HCS08G) || defined (HCS08R) || defined (MC1321X)
void UseExternalClock(void);
void UseMcuClock(void);
#endif
UINT8 IRQPinLow(void);
void SMAC_IRQInit(void);
void MC1319xDrv_Assert_Reset(void);
void MC1319xDrv_Deassert_Reset(void);
UINT8 IRQFLAG(void);
void IRQPinEnable(void); /*!<Enables IRQ pin */
void MC13192_IRQ_Disable(void);
void MC13192_IRQ_Enable(void);
void IRQACK(void);                     /*!< IRQ Acknowledge*/
void MCU_LOW_POWER_WHILE(void);
void MC1319xDrv_TxHighPowerEnable(void);
void MC1319xDrv_TxHighPowerDisable(void);
void MC1319xDrv_RxAntennaSwitchEnable(void);
void MC1319xDrv_TxAntennaSwitchEnable(void);
UINT8 MC13192ReadGPIO1_3Status(void);

void MC13192DisableInterrupts(void);  /* Mask off interrupts from MC13192 */
//extern void RTXENDeAssert(void);             /* Force MC13192 to IDLE */
void MC13192RestoreInterrupts(void);

#ifdef  __cplusplus
}
#endif

#endif /* _MCU_HW_CONFIG_H */
